<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use common\models\Groups;

/* @var $this yii\web\View */
/* @var $model common\models\Packedtasks */
/* @var $form yii\widgets\ActiveForm */
$data = ArrayHelper::map(Groups::find()->asArray()->all(), 'group', 'group');
$model->groups =  json_decode($model->groups); // initial value

?>

<div class="packedtasks-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'name')->textInput() ?>

    <?= $form->field($model, 'created_at')->textInput() ?>

    <?= $form->field($model, 'groups')->widget(Select2::classname(), [
            'data' => $data,
            'options' => ['placeholder' => 'Select groups ...', 'multiple' => true],
            'pluginOptions' => [
                'tags' => true,
                'tokenSeparators' => [',', ' '],
                'maximumInputLength' => 10,
                'maintainOrder' => true
            ],
        ])->label('Access to groups'); ?>

  
	<?php if (!Yii::$app->request->isAjax){ ?>
	  	<div class="form-group">
	        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
	    </div>
	<?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>
